from bpy.types import FieldSettings


def reset_properties_to_defaults(field: FieldSettings) -> None:

    # Le seteo los "por default" basicos, ya que blender los tiene mal sus defaults (los pone en 0):

    # Defino las propiedades y sus valores predeterminados
    default_values = {
        
        # drag:
        'linear_drag':              6, # <- este property afecta al strength normal :S
        'quadratic_drag':           1,
        
        # guide:
        'guide_free':               0,
        'falloff_power':            0,
        'use_guide_path_add':       False,
        'use_guide_path_weight':    False,
        'guide_clump_amount':       0,
        'guide_clump_shape':        0,
        'guide_minimum':            6, # <- este property afecta al strength normal :S
        'use_max_distance':         False,
        'distance_max':             0,

        # generics:
        'shape':                    'POINT',
        'strength':                 1,
        'size':                     0,
        'flow':                     0,
        'rest_length':              0,
        'apply_to_location':        True,
        'apply_to_rotation':        True,
        'noise':                    0,
        'seed':                     1,
        'use_global_coords':        False,
        'use_absorption':           False,
        'use_gravity_falloff':      False,
        'use_multiple_springs':     False,
        'wind_factor':              0,

        # texture:
        'texture_mode':             'RGB',
        'texture_nabla':            0,
        'use_object_coords':        False,
        'use_2d_force':             False,

        # fluid flow:
        'source_object':            None,
        'use_smoke_density':        False,
        
        # harmonic:
        'harmonic_damping':         1,
        'falloff_type':             'SPHERE',
        
        # falloffs:
        'z_direction':              'BOTH',
        'use_min_distance':         False,
        'distance_min':             0,
        'use_max_distance':         False,
        'distance_max':             0,

        # kink:
        'guide_kink_type':          'WAVE',
        'guide_kink_axis':          'X',
        'guide_kink_frequency':     0,
        'guide_kink_shape':         0,
        'guide_kink_amplitude':     0,
    }

    # Itero sobre las propiedades para actualizarlas si son diferentes:
    for prop, default_value in default_values.items():
        current_value = getattr(field, prop)
        if current_value != default_value:
            setattr(field, prop, default_value)